package fm.qingting.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;

import fm.qingting.qtsdk.QTException;
import fm.qingting.qtsdk.QTSDK;
import fm.qingting.qtsdk.callbacks.QTAuthCallBack;
import fm.qingting.qtsdk.entity.UserToken;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        initViews();
    }

    private void initViews() {
        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        findViewById(R.id.bt_login).setOnClickListener(this);
        findViewById(R.id.bt_list).setOnClickListener(this);
        findViewById(R.id.bt_radio_list).setOnClickListener(this);
        findViewById(R.id.bt_pay).setOnClickListener(this);
        findViewById(R.id.bt_search).setOnClickListener(this);
    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.bt_login:
                startActivity(new Intent(this,AuthActivity.class));
                break;
            case R.id.bt_list:
                startActivity(new Intent(this,ListActivity.class));
                break;
            case R.id.bt_radio_list:
                startActivity(new Intent(this,RadioListActivity.class));
                break;
            case R.id.bt_search:
                startActivity(new Intent(this,SearchListActivity.class));
                break;

            case R.id.bt_pay:
                startActivity(new Intent(this,PayTestActivity.class));
                break;
            default:
                break;
        }
    }

}
